/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class SearchResultsList
extends List
implements CommandListener {
    private GoBible goBible;
    private Vector searchResults;

    public SearchResultsList(GoBible goBible, Vector searchResults) {
        super(GoBible.getString("UI-Results") + " - " + Integer.toString(searchResults.size()) + " " + GoBible.getString("UI-Found"), 3);
        this.setFitPolicy(1);
        this.goBible = goBible;
        this.searchResults = searchResults;
        Enumeration e = searchResults.elements();
        while (e.hasMoreElements()) {
            Object[] entry = (Object[])e.nextElement();
            int index = (Integer)entry[0];
            int bookIndex = index >> 16 & 0xFF;
            int chapterIndex = index >> 8 & 0xFF;
            int verseIndex = index & 0xFF;
            this.append(goBible.bibleSource.getBookName(bookIndex) + " " + goBible.bibleSource.getReferenceString(bookIndex, chapterIndex, verseIndex) + " \"" + (String)entry[1] + "\"", null);
        }
        if (goBible.lastSearchIndex >= 0 && goBible.lastSearchIndex < this.size()) {
            this.setSelectedIndex(goBible.lastSearchIndex, true);
            if (!this.isShown()) {
                // empty if block
            }
        }
        this.addCommand(new Command(GoBible.getString("UI-Cancel"), 3, 0));
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        if (command == List.SELECT_COMMAND) {
            int selectedIndex;
            this.goBible.lastSearchIndex = selectedIndex = this.getSelectedIndex();
            int index = (Integer)((Object[])this.searchResults.elementAt(selectedIndex))[0];
            this.goBible.currentBookIndex = index >> 16 & 0xFF;
            this.goBible.currentChapterIndex = index >> 8 & 0xFF;
            this.goBible.currentVerseIndex = index & 0xFF;
            this.goBible.bibleCanvas.enterLoadingMode();
            this.goBible.display.setCurrent((Displayable)this.goBible.bibleCanvas);
            this.goBible.loadCurrentChapter();
            this.goBible.bibleCanvas.update();
        } else {
            switch (command.getCommandType()) {
                case 3: 
                case 4: {
                    this.goBible.bibleCanvas.enterLoadingMode();
                    this.goBible.display.setCurrent((Displayable)this.goBible.bibleCanvas);
                    this.goBible.bibleCanvas.repaint();
                    this.goBible.loadCurrentChapter();
                    this.goBible.showMainScreen();
                }
            }
        }
    }
}

