/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class CombinedChapterBibleSource
extends BibleSource {
    private GoBible goBible = null;
    private Class resourceLoader;
    private int currentBookIndex = -1;
    private int currentFileIndex = -1;
    private int currentChapterIndex = -1;
    private int numberOfBooks;
    private String[] bookNames;
    private String[] shortBookNames;
    private int[] startChapters;
    private int[] numberOfChapters;
    private int[][] combinedChapterIndex;
    private int[][] bookIndex;
    private char[] fileData;
    private char[] verseData;
    private int verseDataSize;

    public CombinedChapterBibleSource(GoBible goBible) throws IOException {
        this(goBible.getClass());
        this.goBible = goBible;
    }

    public CombinedChapterBibleSource(Class resourceLoader) throws IOException {
        this.resourceLoader = resourceLoader;
        DataInputStream input = new DataInputStream(resourceLoader.getResourceAsStream("Bible Data/Index"));
        this.numberOfBooks = input.read();
        this.bookNames = new String[this.numberOfBooks];
        this.shortBookNames = new String[this.numberOfBooks];
        this.startChapters = new int[this.numberOfBooks];
        this.numberOfChapters = new int[this.numberOfBooks];
        this.combinedChapterIndex = new int[this.numberOfBooks][];
        for (int bookIndex = 0; bookIndex < this.numberOfBooks; ++bookIndex) {
            int numberOfChapters;
            this.bookNames[bookIndex] = input.readUTF();
            this.shortBookNames[bookIndex] = input.readUTF();
            this.startChapters[bookIndex] = input.readUnsignedShort();
            this.numberOfChapters[bookIndex] = numberOfChapters = input.readUnsignedShort();
            this.combinedChapterIndex[bookIndex] = new int[numberOfChapters << 2];
            int previousFileNumber = 0;
            int verseDataOffset = 0;
            for (int chapterIndex = 0; chapterIndex < numberOfChapters; ++chapterIndex) {
                int fileNumber = input.read();
                int allVersesLength = input.readInt();
                this.combinedChapterIndex[bookIndex][chapterIndex << 2] = fileNumber;
                if (fileNumber != previousFileNumber) {
                    verseDataOffset = 0;
                    previousFileNumber = fileNumber;
                }
                this.combinedChapterIndex[bookIndex][(chapterIndex << 2) + 1] = verseDataOffset;
                this.combinedChapterIndex[bookIndex][(chapterIndex << 2) + 2] = allVersesLength;
                this.combinedChapterIndex[bookIndex][(chapterIndex << 2) + 3] = input.read();
                verseDataOffset += allVersesLength;
            }
        }
        input.close();
    }

    public char[] getChapter(int bookIndex, int chapterIndex) throws IOException {
        this.loadChapter(bookIndex, chapterIndex);
        return this.verseData;
    }

    public int[] getChapterIndex(int bookIndex, int chapterIndex) throws IOException {
        this.loadChapter(bookIndex, chapterIndex);
        return this.bookIndex[chapterIndex];
    }

    private void loadChapter(int bookIndex, int chapterIndex) throws IOException {
        if (this.currentBookIndex != bookIndex || this.currentChapterIndex != chapterIndex) {
            if (this.currentBookIndex != bookIndex || this.combinedChapterIndex[bookIndex][chapterIndex << 2] != this.currentFileIndex) {
                if (this.goBible != null && this.goBible.display.getCurrent() == this.goBible.bibleCanvas) {
                    this.goBible.bibleCanvas.enterLoadingMode();
                }
                if (this.currentBookIndex != bookIndex) {
                    this.loadBookIndex(bookIndex);
                }
                this.currentFileIndex = this.combinedChapterIndex[bookIndex][chapterIndex << 2];
                DataInputStream input = new DataInputStream(this.resourceLoader.getResourceAsStream("Bible Data/" + this.shortBookNames[bookIndex] + "/" + this.shortBookNames[bookIndex] + " " + this.currentFileIndex));
                int length = input.readInt();
                byte[] byteArray = new byte[length];
                input.readFully(byteArray, 0, length);
                input.close();
                this.fileData = new char[length];
                boolean currentChar = false;
                int charIndex = 0;
                for (int i = 0; i < length; ++i) {
                    int low;
                    int high;
                    int codePoint;
                    byte currentByte = byteArray[i];
                    if ((currentByte & 0x80) == 0) {
                        this.fileData[charIndex] = (char)(currentByte & 0xFF);
                    } else if ((currentByte & 0xE0) == 192) {
                        this.fileData[charIndex] = (char)((currentByte & 0x1F) << 6 | byteArray[++i] & 0x3F);
                    } else if ((currentByte & 0xF0) == 224) {
                        char c = (char)((currentByte & 0xF) << 12 | (byteArray[++i] & 0x3F) << 6);
                        this.fileData[charIndex] = (char)(c | byteArray[++i] & 0x3F);
                    } else if ((currentByte & 0xF8) == 240) {
                        codePoint = (currentByte & 7) << 18 | (byteArray[++i] & 0x3F) << 12;
                        if ((codePoint |= (byteArray[++i] & 0x3F) << 6 | byteArray[++i] & 0x3F) < 65536) {
                            this.fileData[charIndex] = (char)codePoint;
                        } else if (codePoint <= 0x10FFFF) {
                            high = (codePoint - 65536 >> 10) + 55296;
                            low = (codePoint - 65536 & 0x3FF) + 56320;
                            this.fileData[charIndex] = (char)high;
                            this.fileData[++charIndex] = (char)low;
                        } else {
                            this.fileData[charIndex] = 65503;
                        }
                    } else if ((currentByte & 0xFF) == 248) {
                        codePoint = (currentByte & 3) << 24 | (byteArray[++i] & 0x3F) << 18;
                        codePoint |= (byteArray[++i] & 0x3F) << 12 | (byteArray[++i] & 0x3F) << 6;
                        if ((codePoint |= byteArray[++i] & 0x3F) < 65536) {
                            this.fileData[charIndex] = (char)codePoint;
                        } else if (codePoint <= 0x10FFFF) {
                            high = (codePoint - 65536 >> 10) + 55296;
                            low = (codePoint - 65536 & 0x3FF) + 56320;
                            this.fileData[charIndex] = (char)high;
                            this.fileData[++charIndex] = (char)low;
                        } else {
                            this.fileData[charIndex] = 65503;
                        }
                    }
                    ++charIndex;
                }
            }
            this.currentChapterIndex = chapterIndex;
            this.verseDataSize = this.combinedChapterIndex[bookIndex][(chapterIndex << 2) + 2];
            this.verseData = new char[this.verseDataSize];
            System.arraycopy(this.fileData, this.combinedChapterIndex[bookIndex][(chapterIndex << 2) + 1], this.verseData, 0, this.verseDataSize);
        }
    }

    private void loadBookIndex(int bookIndex) throws IOException {
        int numberOfChapters = this.numberOfChapters[bookIndex];
        this.bookIndex = new int[numberOfChapters][];
        this.currentBookIndex = bookIndex;
        DataInputStream input = new DataInputStream(this.resourceLoader.getResourceAsStream("Bible Data/" + this.shortBookNames[bookIndex] + "/Index"));
        for (int chapter = 0; chapter < numberOfChapters; ++chapter) {
            int numberOfVerses = 2 * this.combinedChapterIndex[bookIndex][(chapter << 2) + 3];
            int[] chapterIndex = new int[numberOfVerses];
            this.bookIndex[chapter] = chapterIndex;
            int offset = 0;
            int verse = 0;
            while (verse < numberOfVerses) {
                chapterIndex[verse++] = offset;
                chapterIndex[verse++] = offset += input.readUnsignedShort();
            }
        }
        input.close();
    }

    public String[] getBookNames() {
        return this.bookNames;
    }

    public String getBookName(int bookIndex) {
        return this.bookNames[bookIndex];
    }

    public int getNumberOfBooks() {
        return this.numberOfBooks;
    }

    public int getStartChapter(int bookIndex) {
        return this.startChapters[bookIndex];
    }

    public int getNumberOfChapters(int bookIndex) {
        return this.numberOfChapters[bookIndex];
    }

    public int getNumberOfVerses(int bookIndex, int chapterIndex) {
        return this.combinedChapterIndex[bookIndex][(chapterIndex << 2) + 3];
    }

    public int getVerseDataSize() {
        return this.verseDataSize;
    }
}

