/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class SearchForm
extends Form
implements CommandListener {
    private GoBible goBible;
    private TextField searchTextField;
    private ChoiceGroup bookChoiceGroup;
    private Command searchCommand = new Command(GoBible.getString("UI-Search"), 4, 0);
    private Command cancelCommand = new Command(GoBible.getString("UI-Cancel"), 3, 0);
    private static final int GENESIS = 0;
    private static final int DEUTERONOMY = 4;
    private static final int JOSHUA = 5;
    private static final int ESTHER = 16;
    private static final int JOB = 17;
    private static final int SONG_OF_SOLOMON = 21;
    private static final int ISAIAH = 22;
    private static final int DANIEL = 26;
    private static final int HOSEA = 27;
    private static final int MALACHI = 38;
    private static final int MATTHEW = 39;
    private static final int JOHN = 42;
    private static final int ROMANS = 44;
    private static final int HEBREWS = 57;
    private static final int JAMES = 58;
    private static final int JUDE = 64;
    private static final int REVELATION = 65;
    private static final int[][] BOOK_RANGES = new int[][]{{0, 65}, {-1, -1}, {39, 65}, {0, 38}, {39, 42}, {44, 57}, {58, 64}, {0, 4}, {5, 16}, {17, 21}, {22, 26}, {27, 38}};
    private String[] bookNames;

    public SearchForm(GoBible goBible) {
        super(GoBible.getString("UI-Search"));
        this.goBible = goBible;
        this.searchTextField = new TextField(GoBible.getString("UI-Search-Text") + ":", goBible.lastSearchString, 30, 0);
        this.bookNames = goBible.bibleSource.getBookNames();
        this.bookChoiceGroup = new ChoiceGroup(GoBible.getString("UI-Books") + ":", 1);
        this.bookChoiceGroup.append(GoBible.getString("UI-All"), null);
        this.bookChoiceGroup.append(this.bookNames[goBible.currentBookIndex], null);
        if (this.bookNames.length == 66) {
            this.bookChoiceGroup.append(GoBible.getString("UI-New-Testament"), null);
            this.bookChoiceGroup.append(GoBible.getString("UI-Old-Testament"), null);
            this.bookChoiceGroup.append(GoBible.getString("UI-Gospels"), null);
            this.bookChoiceGroup.append(GoBible.getString("UI-Pauls-Letters"), null);
            this.bookChoiceGroup.append(GoBible.getString("UI-Other-Letters"), null);
            this.bookChoiceGroup.append(GoBible.getString("UI-Books-Of-Moses"), null);
            this.bookChoiceGroup.append(GoBible.getString("UI-Historical"), null);
            this.bookChoiceGroup.append(GoBible.getString("UI-Poetic"), null);
            this.bookChoiceGroup.append(GoBible.getString("UI-Major-Prophets"), null);
            this.bookChoiceGroup.append(GoBible.getString("UI-Minor-Prophets"), null);
        }
        this.bookChoiceGroup.setSelectedIndex(0, true);
        this.append((Item)this.searchTextField);
        this.append((Item)this.bookChoiceGroup);
        this.addCommand(this.searchCommand);
        this.addCommand(this.cancelCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        switch (command.getCommandType()) {
            case 4: {
                if (this.searchTextField.getString().equals("")) break;
                this.goBible.lastSearchString = this.searchTextField.getString();
                int selectedIndex = this.bookChoiceGroup.getSelectedIndex();
                int from = 0;
                int to = 0;
                if (selectedIndex == 0) {
                    to = this.bookNames.length - 1;
                } else if (selectedIndex == 1) {
                    from = to = this.goBible.currentBookIndex;
                } else if (selectedIndex > 1) {
                    from = BOOK_RANGES[selectedIndex][0];
                    to = BOOK_RANGES[selectedIndex][1];
                }
                this.goBible.display.setCurrent((Displayable)new SearchingCanvas(this.goBible, from, to, this.goBible.lastSearchString));
                break;
            }
            case 2: 
            case 3: {
                this.goBible.showMainScreen();
            }
        }
    }
}

