/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GoBible
extends MIDlet
implements Runnable {
    public static final boolean USE_MIDP20 = true;
    public static final String UI_PROPERTIES_FILE_NAME = "/ui.properties";
    public static final String GBCoreVer = "2.4.2";
    public static final int FONT_SIZE_SMALL = 0;
    public static final int FONT_SIZE_MEDIUM = 1;
    public static final int FONT_SIZE_LARGE = 2;
    public static final int[] FONT_SIZE_MAP = new int[]{8, 0, 16};
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int THEME_PAPER = 0;
    public static final int THEME_COMPUTER = 1;
    public static final int THEME_FLORAL = 2;
    public static final int THEME_NATURAL = 3;
    public static final int THEME_BLUE = 4;
    public static final int THEME_SUNSHINE = 5;
    public static final int[] THEME_TEXT_COLOUR = new int[]{0, 65280, 0x660066, 0x883300, 136, 26112};
    public static final int[] THEME_BACK_COLOUR = new int[]{0xFFFFFF, 0, 0xFFDDF0, 0xFFFFCC, 0xDDEEFF, 0xFFFF00};
    public static final int[] THEME_HIGHLIGHT_COLOUR = new int[]{0xE0E0FF, 21760, 0xDDC0DD, 0xCCFFCC, 0xFFFFFF, 0xBBFF00};
    public static final int[] THEME_CHRIST_COLOUR = new int[]{0xC00000, 0xFF8800, 26214, 26112, 0xD00000, 0xDD4400};
    public static int PREFS_FONT_SIZE = 0;
    public static int PREFS_BOOK = 1;
    public static int PREFS_CHAPTER = 2;
    public static int PREFS_VERSE = 3;
    public static Hashtable uiProperties = new Hashtable();
    public Display display;
    public BibleCanvas bibleCanvas;
    private PrefsForm prefsForm;
    private boolean firstRun = true;
    public int currentBookIndex = 0;
    public int currentChapterIndex = 0;
    public int currentVerseIndex = 0;
    public int fontSize = 1;
    public int fontStyle = 0;
    public boolean fullScreen = false;
    public int theme = 0;
    public boolean reverseColours = false;
    public static int[] verseIndex;
    public static char[] verseData;
    public BibleSource bibleSource;
    public String lastSearchString = "";
    public int lastFromBook = -1;
    public int lastToBook = -1;
    public boolean searchCanSpanMultipleVerses = false;
    Vector searchResults = new Vector();
    public int lastSearchIndex = 0;
    Vector bookmarks = new Vector();
    public static final int HISTORY_SIZE = 20;
    public static final int HISTORY_EXCERPT_SIZE = 30;
    public int historyStartIndex = 0;
    public byte[] historyVerseIndices = new byte[60];
    public String[] historyExcerpts = new String[20];
    Timer backlightTimer;
    TimerTask backlightTask;
    public long fromJarTime;
    public long readUTFTime;
    public long readBytesTime;
    public long byteToStringTime;
    public long byteToCharTime;
    public long loadChapterTime;
    public long skipTime;
    private static GoBible lastInstance;

    public GoBible() {
        lastInstance = this;
    }

    public static GoBible getInstance() {
        return lastInstance;
    }

    public void startApp() {
        this.turnOnBacklight();
        if (this.firstRun) {
            this.firstRun = false;
            this.readUiProperties();
            this.display = Display.getDisplay((MIDlet)this);
            try {
                this.bibleCanvas = new BibleCanvas(this);
                this.bibleCanvas.init();
                this.display.setCurrent((Displayable)this.bibleCanvas);
                this.readPreferences();
                this.readBookmarks();
                this.readHistory();
                this.bibleCanvas.setFullScreenMode(this.fullScreen);
                new Thread(this).start();
            }
            catch (Throwable e) {
                Form form = new Form("Error");
                form.append(e.toString());
                this.display.setCurrent((Displayable)form);
            }
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.writePreferences();
        this.writeBookmarks();
        this.writeHistory();
        if (this.backlightTimer != null) {
            this.backlightTimer.cancel();
        }
    }

    public void run() {
        boolean error = false;
        try {
            this.bibleSource = new CombinedChapterBibleSource(this);
            this.loadCurrentChapter();
        }
        catch (IOException e) {
            error = true;
            System.out.println("Error");
            this.display.setCurrent((Displayable)new Alert(GoBible.getString("UI-Error"), e.toString(), null, AlertType.ERROR));
        }
        if (!error) {
            this.showMainScreen();
        }
    }

    public void turnOnBacklight() {
    }

    public void showMainScreen() {
        int textColour = THEME_TEXT_COLOUR[this.theme];
        int backColour = THEME_BACK_COLOUR[this.theme];
        if (this.reverseColours) {
            int temp = textColour;
            textColour = backColour;
            this.bibleCanvas.highlightColour = backColour = temp;
        } else {
            this.bibleCanvas.highlightColour = THEME_HIGHLIGHT_COLOUR[this.theme];
        }
        this.bibleCanvas.textColour = textColour;
        this.bibleCanvas.backColour = backColour;
        this.bibleCanvas.christWordsColour = THEME_CHRIST_COLOUR[this.theme];
        this.display.setCurrent((Displayable)this.bibleCanvas);
        this.bibleCanvas.setFullScreenMode(this.fullScreen);
        this.bibleCanvas.update();
    }

    public void addBookmark() {
        try {
            BookmarkEntry bookmark = new BookmarkEntry(this.currentBookIndex, this.currentChapterIndex, this.currentVerseIndex, this.getExcerpt(this.currentBookIndex, this.currentChapterIndex, this.currentVerseIndex));
            this.bookmarks.insertElementAt(bookmark, 0);
            this.showBookmarksScreen();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void showBookmarksScreen() {
        this.display.setCurrent((Displayable)new BookmarksList(this));
    }

    public void showHistoryScreen() {
        this.display.setCurrent((Displayable)new HistoryList(this));
    }

    public void showSendSMSScreen() {
        this.display.setCurrent((Displayable)new SendSMSForm(this, 0));
    }

    public void showSendMMSScreen() {
    }

    public void showSearchScreen() {
        this.display.setCurrent((Displayable)new SearchForm(this));
    }

    public void showSearchResultsScreen() {
        this.display.setCurrent((Displayable)new SearchResultsList(this, this.searchResults));
    }

    public void showPrefsScreen() {
        PrefsForm prefsForm = new PrefsForm(this);
        this.display.setCurrent((Displayable)prefsForm);
    }

    public void showAboutAlert() {
        String infoString = this.getAppProperty("Go-Bible-Info");
        String safeAppName = this.getAppProperty("Go-Bible-Safe-Name");
        String regAppName = this.getAppProperty("Application-Name");
        String midletVersion = this.getAppProperty("MIDlet-Version");
        String midletName = this.getAppProperty("MIDlet-Name");
        String midletInfoUrl = this.getAppProperty("MIDlet-Info-URL");
        String midletVendor = this.getAppProperty("MIDlet-Vendor");
        if (midletVendor == null) {
            midletVendor = "";
        }
        if (midletInfoUrl == null) {
            midletInfoUrl = "";
        }
        if (infoString == null) {
            infoString = "";
        }
        if (safeAppName == null) {
            safeAppName = regAppName == null ? "Go Bible" : regAppName;
        }
        this.display.setCurrent((Displayable)new Alert(GoBible.getString("UI-About") + " " + safeAppName, "Vendor: " + midletVendor + "\n" + midletInfoUrl + "\n\"For the glory of our Lord Jesus Christ and the furtherance of His Kingdom\"\n" + infoString + " Viewer Version: " + GBCoreVer, null, AlertType.INFO));
    }

    public void gotoPassage(int bookIndex, int chapterIndex, int verseIndex) {
        boolean error = false;
        String bookName = null;
        if (bookIndex != this.currentBookIndex || chapterIndex != this.currentChapterIndex || verseIndex != this.currentVerseIndex) {
            int numberOfVerses;
            this.currentBookIndex = bookIndex;
            this.currentChapterIndex = chapterIndex;
            this.currentVerseIndex = verseIndex;
            int numberOfChapters = this.bibleSource.getNumberOfChapters(bookIndex);
            if (chapterIndex >= numberOfChapters) {
                error = true;
                this.currentChapterIndex = numberOfChapters - 1;
            }
            if (verseIndex >= (numberOfVerses = this.bibleSource.getNumberOfVerses(this.currentBookIndex, this.currentChapterIndex))) {
                error = true;
                this.currentVerseIndex = numberOfVerses - 1;
            }
            bookName = this.bibleSource.getBookName(bookIndex);
        }
        this.bibleCanvas.enterLoadingMode();
        this.loadCurrentChapter();
        try {
            --this.historyStartIndex;
            if (this.historyStartIndex < 0) {
                this.historyStartIndex = 19;
            }
            this.historyVerseIndices[this.historyStartIndex * 3] = (byte)this.currentBookIndex;
            this.historyVerseIndices[this.historyStartIndex * 3 + 1] = (byte)this.currentChapterIndex;
            this.historyVerseIndices[this.historyStartIndex * 3 + 2] = (byte)this.currentVerseIndex;
            this.historyExcerpts[this.historyStartIndex] = this.getExcerpt(this.currentBookIndex, this.currentChapterIndex, this.currentVerseIndex);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.bibleCanvas.update();
    }

    public String getExcerpt(int bookIndex, int chapterIndex, int verseIndex) throws IOException {
        int excerptSize;
        int[] verseIndices = this.bibleSource.getChapterIndex(bookIndex, chapterIndex);
        int verseOffset = verseIndices[verseIndex * 2];
        int verseEndOffset = 0;
        int numberOfVerses = this.bibleSource.getNumberOfVerses(bookIndex, chapterIndex);
        verseEndOffset = verseIndex < numberOfVerses - 1 ? verseIndices[(verseIndex + 1) * 2] : this.bibleSource.getVerseDataSize();
        char[] verseData = this.bibleSource.getChapter(bookIndex, chapterIndex);
        if (verseEndOffset - verseOffset < 30) {
            excerptSize = verseEndOffset - verseOffset;
        } else {
            char nextChar;
            for (excerptSize = 30; excerptSize < verseEndOffset - verseOffset && (nextChar = verseData[verseOffset + excerptSize]) != ' ' && nextChar != '.' && nextChar != ',' && nextChar != ';'; ++excerptSize) {
            }
        }
        char[] chars = new char[excerptSize];
        int j = 0;
        for (int i = verseOffset; i < verseOffset + excerptSize; ++i) {
            if (verseData[i] < '\n') continue;
            chars[j++] = verseData[i];
        }
        String excerpt = new String(chars, 0, j);
        if (excerptSize < verseEndOffset - verseOffset) {
            excerpt = excerpt + '\u2026';
        }
        return excerpt;
    }

    public void scrollPrevious() {
        --this.currentVerseIndex;
        if (this.currentVerseIndex < 0) {
            this.previousChapter(true);
        }
    }

    public void scrollNext() {
        ++this.currentVerseIndex;
        if (this.currentVerseIndex >= this.bibleSource.getNumberOfVerses(this.currentBookIndex, this.currentChapterIndex)) {
            this.nextChapter();
        }
    }

    public void previousChapter(boolean lastVerse) {
        --this.currentChapterIndex;
        if (this.currentChapterIndex < 0) {
            this.previousBook(false);
            this.currentChapterIndex = this.bibleSource.getNumberOfChapters(this.currentBookIndex) - 1;
        }
        this.currentVerseIndex = lastVerse ? this.bibleSource.getNumberOfVerses(this.currentBookIndex, this.currentChapterIndex) - 1 : 0;
        this.loadCurrentChapter();
    }

    public void nextChapter() {
        ++this.currentChapterIndex;
        if (this.currentChapterIndex >= this.bibleSource.getNumberOfChapters(this.currentBookIndex)) {
            this.nextBook(false);
        }
        this.currentVerseIndex = 0;
        this.loadCurrentChapter();
    }

    public boolean isLastBook() {
        return this.currentBookIndex == this.bibleSource.getNumberOfBooks();
    }

    public boolean isFirstBook() {
        return this.currentBookIndex == 0;
    }

    public void previousBook(boolean load) {
        --this.currentBookIndex;
        if (this.currentBookIndex < 0) {
            this.currentBookIndex = this.bibleSource.getNumberOfBooks() - 1;
        }
        this.currentVerseIndex = 0;
        this.currentChapterIndex = 0;
        if (load) {
            this.loadCurrentChapter();
        }
    }

    public void nextBook(boolean load) {
        ++this.currentBookIndex;
        if (this.currentBookIndex >= this.bibleSource.getNumberOfBooks()) {
            this.currentBookIndex = 0;
        }
        this.currentVerseIndex = 0;
        this.currentChapterIndex = 0;
        if (load) {
            this.loadCurrentChapter();
        }
    }

    private void readUiProperties() {
        try {
            InputStream input = this.getClass().getResourceAsStream(UI_PROPERTIES_FILE_NAME);
            byte[] fileData = new byte[32768];
            int offset = 0;
            int bytesRead = 0;
            while ((bytesRead = input.read(fileData, offset, fileData.length - offset)) != -1) {
                offset += bytesRead;
            }
            input.close();
            String uiPropertiesString = new String(fileData, 0, offset, "UTF-8");
            int startOfLineIndex = 0;
            int endOfLineIndex = uiPropertiesString.indexOf(10);
            while (endOfLineIndex != -1) {
                this.readUiPropertiesLine(uiPropertiesString, startOfLineIndex, endOfLineIndex);
                startOfLineIndex = endOfLineIndex + 1;
                endOfLineIndex = uiPropertiesString.indexOf(10, startOfLineIndex);
            }
            this.readUiPropertiesLine(uiPropertiesString, startOfLineIndex, uiPropertiesString.length());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readUiPropertiesLine(String uiPropertiesString, int startOfLineIndex, int endOfLineIndex) {
        String lineString = uiPropertiesString.substring(startOfLineIndex, endOfLineIndex);
        int colonIndex = lineString.indexOf(58);
        if (colonIndex >= 0) {
            String propertyName = lineString.substring(0, colonIndex).trim();
            String uiString = lineString.substring(colonIndex + 1, lineString.length()).trim();
            uiProperties.put(propertyName, uiString);
        }
    }

    public static String getString(String propertyName) {
        String result = (String)uiProperties.get(propertyName);
        if (result == null) {
            result = propertyName;
        }
        return result;
    }

    private void readPreferences() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"Preferences", (boolean)true);
            if (store.getNumRecords() > 0) {
                byte[] data = store.getRecord(1);
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
                this.fontSize = input.readByte();
                this.currentBookIndex = input.read();
                this.currentChapterIndex = input.read();
                this.currentVerseIndex = input.read();
                this.lastSearchString = input.readUTF();
                this.fullScreen = input.readBoolean();
                BibleCanvas.reverseCharacters = input.readBoolean();
                this.theme = input.readByte();
                this.reverseColours = input.readBoolean();
                this.fontStyle = input.readByte();
                this.lastFromBook = input.readByte();
                this.lastToBook = input.readByte();
                input.close();
            }
        }
        catch (IOException ee) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void writePreferences() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"Preferences", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
            output.write(this.fontSize);
            output.write(this.currentBookIndex);
            output.write(this.currentChapterIndex);
            output.write(this.currentVerseIndex);
            output.writeUTF(this.lastSearchString);
            output.writeBoolean(this.fullScreen);
            output.writeBoolean(BibleCanvas.reverseCharacters);
            output.write(this.theme);
            output.writeBoolean(this.reverseColours);
            output.write(this.fontStyle);
            output.write(this.lastFromBook);
            output.write(this.lastToBook);
            output.close();
            byte[] data = byteArrayOutputStream.toByteArray();
            if (store.getNumRecords() > 0) {
                store.setRecord(1, data, 0, data.length);
            } else {
                store.addRecord(data, 0, data.length);
            }
        }
        catch (IOException e) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void readBookmarks() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"Bookmarks", (boolean)true);
            if (store.getNumRecords() > 0) {
                byte[] data = store.getRecord(1);
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
                int numberOfBookmarks = input.readUnsignedShort();
                for (int i = 0; i < numberOfBookmarks; ++i) {
                    BookmarkEntry bookmark = new BookmarkEntry(input);
                    this.bookmarks.addElement(bookmark);
                }
                input.close();
            }
        }
        catch (IOException ee) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void writeBookmarks() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"Bookmarks", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
            output.writeShort(this.bookmarks.size());
            Enumeration e = this.bookmarks.elements();
            while (e.hasMoreElements()) {
                BookmarkEntry bookmark = (BookmarkEntry)e.nextElement();
                bookmark.write(output);
            }
            output.close();
            byte[] data = byteArrayOutputStream.toByteArray();
            if (store.getNumRecords() > 0) {
                store.setRecord(1, data, 0, data.length);
            } else {
                store.addRecord(data, 0, data.length);
            }
        }
        catch (IOException e) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void readHistory() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"History", (boolean)true);
            if (store.getNumRecords() > 0) {
                byte[] data = store.getRecord(1);
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
                this.historyStartIndex = input.readByte();
                int j = 0;
                for (int i = 0; i < 20; ++i) {
                    this.historyVerseIndices[j++] = input.readByte();
                    this.historyVerseIndices[j++] = input.readByte();
                    this.historyVerseIndices[j++] = input.readByte();
                    this.historyExcerpts[i] = input.readUTF();
                }
                input.close();
            }
        }
        catch (IOException ee) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void writeHistory() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"History", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
            output.writeByte(this.historyStartIndex);
            int j = 0;
            for (int i = 0; i < 20; ++i) {
                output.writeByte(this.historyVerseIndices[j++]);
                output.writeByte(this.historyVerseIndices[j++]);
                output.writeByte(this.historyVerseIndices[j++]);
                output.writeUTF(this.historyExcerpts[i] == null ? "" : this.historyExcerpts[i]);
            }
            output.close();
            byte[] data = byteArrayOutputStream.toByteArray();
            if (store.getNumRecords() > 0) {
                store.setRecord(1, data, 0, data.length);
            } else {
                store.addRecord(data, 0, data.length);
            }
        }
        catch (IOException e) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void loadCurrentChapter() {
        try {
            verseData = this.bibleSource.getChapter(this.currentBookIndex, this.currentChapterIndex);
            verseIndex = this.bibleSource.getChapterIndex(this.currentBookIndex, this.currentChapterIndex);
        }
        catch (IOException e) {
            System.out.println("IOException in loadCurrentChapter()");
        }
    }

    public String localizeDigits(String s) {
        String digits = null;
        StringBuffer buffer = new StringBuffer();
        digits = GoBible.getString("UI-Digits");
        if (digits.equals("UI-Digits")) {
            return s;
        }
        if (digits.length() < 10) {
            return s;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            buffer.append(digits.charAt(s.charAt(i) - 48));
        }
        return buffer.toString();
    }

    static {
        lastInstance = null;
    }
}

