/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class BibleCanvas
extends Canvas
implements CommandListener {
    private static final boolean DEBUG = false;
    private static final int TEXT_BORDER_LEFT = 3;
    private static final int TEXT_BORDER_RIGHT = 3;
    private static final int BAR_PADDING = 2;
    private static final int BOX_CORNER = 10;
    private static final int MODE_SPLASH = 0;
    private static final int MODE_LOADING = 1;
    private static final int MODE_VIEWING = 2;
    private static final int MODE_GOTO = 3;
    private static final int SELECTION_BOOK = 0;
    private static final int SELECTION_CHAPTER = 1;
    private static final int SELECTION_VERSE = 2;
    private static final int SELECTION_BORDER = 5;
    private static final int ALIGN_LEFT = 0;
    private static final int ALIGN_RIGHT = 1;
    private static final char STYLE_RED = '\u0001';
    private static final int COLOUR_RED = 0xB00000;
    private static final int HIGHLIGHT_BACKGROUND_COLOUR = 0xE0E0FF;
    private static final int HIGHLIGHT_OUTLINE_COLOUR = 0xC0C0FF;
    private GoBible goBible;
    private Command gotoCommand = new Command(GoBible.getString("UI-Goto"), 4, 0);
    private Command searchCommand = new Command(GoBible.getString("UI-Search"), 1, 0);
    private Command searchResultsCommand = new Command(GoBible.getString("UI-Search-Results"), 1, 0);
    private Command addBookmarkCommand = new Command(GoBible.getString("UI-Add-Bookmark"), 1, 0);
    private Command bookmarksCommand = new Command(GoBible.getString("UI-Bookmarks"), 1, 0);
    private Command historyCommand = new Command(GoBible.getString("UI-History"), 1, 0);
    private Command sendSMSCommand;
    private Command sendMMSCommand;
    private Command prefsCommand = new Command(GoBible.getString("UI-Preferences"), 1, 0);
    private Command aboutCommand = new Command(GoBible.getString("UI-About"), 1, 0);
    private Command exitCommand = new Command(GoBible.getString("UI-Exit"), 7, 0);
    private Command cancelCommand = new Command(GoBible.getString("UI-Cancel"), 3, 0);
    private String ofString = GoBible.getString("UI-Of");
    private int mode = 0;
    int textColour = 0;
    int backColour = 0xFFFFFF;
    int christWordsColour = 0xD00000;
    int highlightColour = 0xE0E0FF;
    int align;
    int anchor;
    static boolean reverseCharacters;
    int width;
    int height;
    private int firstX;
    private int firstY;
    private int diffX;
    private int diffY;
    int lineStart;
    int lastSpace;
    int y;
    int drawX;
    private boolean moreVerseDown;
    private int[] scrollPoints = new int[100];
    private boolean[] scrollStyleRed = new boolean[100];
    private int currentScrollPointIndex = -1;
    private int currentScrollPoint = -1;
    private boolean currentScrollStyle;
    private int nextScrollPointVerse = -1;
    private int nextScrollPoint;
    private boolean nextScrollStyle;
    private int[] selection = new int[3];
    private int selectionIndex = 0;
    private boolean editingSelection;
    private static final int SCROLL_SLOW = 9;
    private static final int SCROLL_MED = 13;
    private static final int SCROLL_FAST = 18;
    private int throwAwayScrollCount = 0;

    public BibleCanvas(GoBible goBible) {
        this.goBible = goBible;
    }

    protected void pointerPressed(int x, int y) {
        this.firstX = x;
        this.firstY = y;
        this.diffY = 0;
        this.diffX = 0;
    }

    protected void pointerDragged(int x, int y) {
        if (y == this.firstY) {
            return;
        }
        if (this.throwAwayScrollCount > 0) {
            this.firstX = x;
            this.firstY = y;
            --this.throwAwayScrollCount;
            return;
        }
        boolean didWork = false;
        this.diffX = Math.abs(this.firstX - x);
        this.diffY = Math.abs(this.firstY - y);
        if (this.diffY > this.diffX) {
            if (this.diffY >= 9 && this.diffY <= 12) {
                if (y > this.firstY) {
                    this.keyPressed(51);
                } else {
                    this.keyPressed(54);
                }
                didWork = true;
            } else if (this.diffY >= 13 && this.diffY <= 17) {
                if (y > this.firstY) {
                    this.keyPressed(50);
                } else {
                    this.keyPressed(53);
                }
                didWork = true;
                this.throwAwayScrollCount = 8;
            } else if (this.diffY >= 18) {
                if (y > this.firstY) {
                    if (!this.goBible.isFirstBook()) {
                        this.keyPressed(49);
                    }
                } else if (!this.goBible.isLastBook()) {
                    this.keyPressed(52);
                }
                didWork = true;
                this.throwAwayScrollCount = 25;
            }
            if (didWork) {
                this.update();
                this.firstX = x;
                this.firstY = y;
            }
        }
    }

    public void init() {
        String alignmentString = this.goBible.getAppProperty("Go-Bible-Align");
        if (alignmentString == null || alignmentString.equals("Left")) {
            this.align = 0;
            this.anchor = 20;
        } else if (alignmentString.equals("Right")) {
            this.align = 1;
            this.anchor = 24;
        }
        try {
            Class.forName("javax.wireless.messaging.MessageConnection");
            this.sendSMSCommand = new Command(GoBible.getString("UI-Send-SMS"), 1, 0);
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.goBible.fullScreen) {
            this.addCommand(this.gotoCommand);
        }
        this.addCommands();
    }

    public void addCommands() {
        if (this.goBible.fullScreen) {
            this.addCommand(this.gotoCommand);
        }
        this.addCommand(this.searchCommand);
        this.addCommand(this.searchResultsCommand);
        this.addCommand(this.addBookmarkCommand);
        this.addCommand(this.bookmarksCommand);
        this.addCommand(this.historyCommand);
        if (this.sendSMSCommand != null) {
            this.addCommand(this.sendSMSCommand);
        }
        if (this.sendMMSCommand != null) {
            // empty if block
        }
        this.addCommand(this.prefsCommand);
        this.addCommand(this.aboutCommand);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
    }

    public void showNotify() {
        this.goBible.turnOnBacklight();
    }

    public void commandAction(Command command, Displayable display) {
        switch (command.getCommandType()) {
            case 7: {
                this.goBible.destroyApp(false);
                this.goBible.notifyDestroyed();
                break;
            }
            case 4: {
                if (command == this.gotoCommand) {
                    this.enterGotoMode();
                }
            }
            case 1: {
                if (command == this.prefsCommand) {
                    this.goBible.showPrefsScreen();
                    break;
                }
                if (command == this.aboutCommand) {
                    this.goBible.showAboutAlert();
                    break;
                }
                if (command == this.historyCommand) {
                    this.goBible.showHistoryScreen();
                    break;
                }
                if (command == this.sendSMSCommand) {
                    this.goBible.showSendSMSScreen();
                    break;
                }
                if (command == this.sendMMSCommand) {
                    this.goBible.showSendMMSScreen();
                    break;
                }
                if (command == this.searchCommand) {
                    this.goBible.showSearchScreen();
                    break;
                }
                if (command == this.searchResultsCommand) {
                    this.goBible.showSearchResultsScreen();
                    break;
                }
                if (command == this.addBookmarkCommand) {
                    this.goBible.addBookmark();
                    break;
                }
                if (command != this.bookmarksCommand) break;
                this.goBible.showBookmarksScreen();
                break;
            }
            case 2: 
            case 3: {
                if (this.mode == 3) {
                    this.removeCommand(this.cancelCommand);
                    this.addCommands();
                } else if (this.mode == 2) {
                    this.goBible.destroyApp(false);
                    this.goBible.notifyDestroyed();
                }
                this.mode = 2;
                this.repaint();
                this.serviceRepaints();
            }
        }
    }

    public void keyPressed(int keyCode) {
        boolean keyHandled = false;
        if (this.mode == 2) {
            switch (keyCode) {
                case 50: {
                    this.goBible.previousChapter(false);
                    keyHandled = true;
                    break;
                }
                case 53: {
                    this.goBible.nextChapter();
                    keyHandled = true;
                    break;
                }
                case 49: {
                    this.goBible.previousBook(true);
                    keyHandled = true;
                    break;
                }
                case 52: {
                    this.goBible.nextBook(true);
                    keyHandled = true;
                }
            }
            if (keyHandled) {
                this.update();
            } else {
                int gameAction = this.getGameAction(keyCode);
                if (gameAction == 1 || keyCode == 51) {
                    if (this.currentScrollPointIndex > 0) {
                        --this.currentScrollPointIndex;
                        this.repaint();
                        this.serviceRepaints();
                    } else if (this.currentScrollPoint >= 0) {
                        this.update();
                    } else {
                        this.goBible.scrollPrevious();
                        this.update();
                    }
                } else if (gameAction == 6 || keyCode == 54) {
                    if (this.moreVerseDown) {
                        ++this.currentScrollPointIndex;
                        this.repaint();
                        this.serviceRepaints();
                    } else if (this.nextScrollPointVerse >= 0) {
                        this.goBible.currentVerseIndex = this.nextScrollPointVerse;
                        this.currentScrollPoint = this.nextScrollPoint;
                        this.currentScrollStyle = this.nextScrollStyle;
                        this.currentScrollPointIndex = -1;
                        this.repaint();
                        this.serviceRepaints();
                    } else {
                        this.goBible.nextChapter();
                        this.update();
                    }
                } else if (gameAction == 8) {
                    this.enterGotoMode();
                }
            }
        } else if (this.mode == 3) {
            int startIndex = 1;
            if (this.selectionIndex == 1) {
                startIndex = this.goBible.bibleSource.getStartChapter(this.selection[0]);
            }
            if (this.selectionIndex >= 1 && keyCode >= 48 && keyCode <= 57) {
                int value = keyCode - 48;
                int index = this.selection[this.selectionIndex];
                if (!this.editingSelection) {
                    if (keyCode != 48) {
                        this.editingSelection = true;
                        this.selection[this.selectionIndex] = value - startIndex;
                    }
                } else if (index + startIndex < 100) {
                    this.selection[this.selectionIndex] = (index + startIndex) * 10 + value - startIndex;
                }
            } else {
                this.editingSelection = false;
                int gameAction = this.getGameAction(keyCode);
                if (keyCode == 42) {
                    gameAction = 2;
                } else if (keyCode == 35) {
                    gameAction = 5;
                }
                if (gameAction == 0) {
                    if (keyCode == -6) {
                        gameAction = 9;
                    } else if (keyCode == -7) {
                        gameAction = 10;
                    }
                }
                switch (gameAction) {
                    case 2: {
                        --this.selectionIndex;
                        if (this.selectionIndex >= 0) break;
                        this.selectionIndex = 2;
                        break;
                    }
                    case 5: {
                        ++this.selectionIndex;
                        this.selectionIndex %= 3;
                        break;
                    }
                    case 1: {
                        int n = this.selectionIndex;
                        this.selection[n] = this.selection[n] - 1;
                        break;
                    }
                    case 6: {
                        int n = this.selectionIndex;
                        this.selection[n] = this.selection[n] + 1;
                        break;
                    }
                    case 8: {
                        this.enterGotoMode();
                        break;
                    }
                    case 10: {
                        this.addCommands();
                        this.mode = 2;
                        this.repaint();
                        this.serviceRepaints();
                    }
                }
                this.validateSelection();
            }
            this.repaint();
            this.serviceRepaints();
        }
        this.goBible.turnOnBacklight();
    }

    private boolean validateSelection() {
        boolean correct = true;
        int numberOfBooks = this.goBible.bibleSource.getNumberOfBooks();
        if (this.selection[0] >= numberOfBooks) {
            this.selection[0] = 0;
            correct = false;
        } else if (this.selection[0] < 0) {
            this.selection[0] = numberOfBooks - 1;
            correct = false;
        }
        int numberOfChapters = this.goBible.bibleSource.getNumberOfChapters(this.selection[0]);
        if (this.selection[1] >= numberOfChapters) {
            this.selection[1] = 0;
            correct = false;
        } else if (this.selection[1] < 0) {
            this.selection[1] = numberOfChapters - 1;
            correct = false;
        }
        int numberOfVerses = this.goBible.bibleSource.getNumberOfVerses(this.selection[0], this.selection[1]);
        if (this.selection[2] >= numberOfVerses) {
            this.selection[2] = 0;
            correct = false;
        } else if (this.selection[2] < 0) {
            this.selection[2] = numberOfVerses - 1;
            correct = false;
        }
        return correct;
    }

    public void enterLoadingMode() {
        this.mode = 1;
        this.repaint();
        this.serviceRepaints();
    }

    public void update() {
        if (this.mode == 3) {
            // empty if block
        }
        this.removeCommand(this.cancelCommand);
        this.addCommands();
        this.mode = 2;
        this.moreVerseDown = false;
        this.currentScrollPointIndex = -1;
        this.currentScrollPoint = -1;
        this.currentScrollStyle = false;
        this.repaint();
        this.serviceRepaints();
    }

    public void enterGotoMode() {
        if (this.mode == 2) {
            this.mode = 3;
            this.selection[0] = this.goBible.currentBookIndex;
            this.selection[1] = this.goBible.currentChapterIndex;
            this.selection[2] = this.goBible.currentVerseIndex;
            this.removeCommand(this.historyCommand);
            this.removeCommand(this.addBookmarkCommand);
            this.removeCommand(this.bookmarksCommand);
            this.removeCommand(this.searchCommand);
            this.removeCommand(this.searchResultsCommand);
            this.removeCommand(this.prefsCommand);
            this.removeCommand(this.aboutCommand);
            this.removeCommand(this.exitCommand);
            if (this.sendSMSCommand != null) {
                this.removeCommand(this.sendSMSCommand);
            }
            if (this.sendMMSCommand != null) {
                this.removeCommand(this.sendMMSCommand);
            }
            if (this.goBible.fullScreen) {
                this.removeCommand(this.gotoCommand);
                this.setCommandListener(null);
            } else {
                this.addCommand(this.cancelCommand);
            }
            this.repaint();
            this.serviceRepaints();
            this.editingSelection = false;
        } else if (this.mode == 3 && this.validateSelection()) {
            this.goBible.gotoPassage(this.selection[0], this.selection[1], this.selection[2]);
        }
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void paint(Graphics g) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.mode == 1) {
            this.paintLoading(g);
        } else if (this.mode == 2) {
            int numberOfVerses = this.goBible.bibleSource.getNumberOfVerses(this.goBible.currentBookIndex, this.goBible.currentChapterIndex);
            Font boldFont = Font.getFont((int)0, (int)1, (int)GoBible.FONT_SIZE_MAP[this.goBible.fontSize]);
            int barHeight = 4 + boldFont.getHeight();
            g.setColor(this.highlightColour);
            g.fillRect(0, 0, this.width, barHeight);
            g.setColor(this.backColour);
            g.fillRect(0, barHeight, this.width, this.height - barHeight);
            g.setFont(boldFont);
            String bookName = this.goBible.bibleSource.getBookName(this.goBible.currentBookIndex);
            String referenceString = " " + this.goBible.bibleSource.getReferenceString(this.goBible.currentBookIndex, this.goBible.currentChapterIndex, this.goBible.currentVerseIndex);
            int bookNameWidth = boldFont.stringWidth(bookName);
            int referenceStringWidth = boldFont.stringWidth(referenceString);
            int ofStringWidth = boldFont.stringWidth(" " + this.ofString + " " + this.goBible.localizeDigits(numberOfVerses + ""));
            int coreWidth = bookNameWidth + referenceStringWidth + 4;
            if (coreWidth + ofStringWidth <= this.width) {
                g.setColor(this.textColour);
                g.drawString(" " + this.ofString + " " + this.goBible.localizeDigits(numberOfVerses + ""), this.width - 2, 2, 24);
            } else {
                ofStringWidth = 0;
            }
            g.setColor(this.textColour);
            g.drawString(referenceString, this.width - 2 - ofStringWidth, 2, 24);
            if (coreWidth + ofStringWidth > this.width) {
                g.clipRect(0, 0, this.width - (2 + referenceStringWidth + ofStringWidth), this.height);
            }
            BibleCanvas.drawString(g, bookName, 2, 2, 20);
            Font plainFont = Font.getFont((int)0, (int)(this.goBible.fontStyle == 1 ? 1 : 0), (int)GoBible.FONT_SIZE_MAP[this.goBible.fontSize]);
            int textWrap = this.width - 3;
            int fontHeight = plainFont.getHeight();
            this.y = barHeight + 2;
            this.moreVerseDown = false;
            g.setClip(0, this.y, this.width, this.height - this.y);
            boolean styleRed = false;
            char[] verse = GoBible.verseData;
            g.setColor(this.textColour);
            for (int verseIndex = this.goBible.currentVerseIndex; verseIndex < numberOfVerses && this.y + fontHeight <= this.height; ++verseIndex) {
                int verseOffset = GoBible.verseIndex[verseIndex << 1];
                int verseEnd = GoBible.verseIndex[(verseIndex << 1) + 1];
                this.drawX = 3;
                this.lineStart = verseOffset;
                this.lastSpace = -1;
                int startChar = verseOffset;
                if (verseIndex == this.goBible.currentVerseIndex) {
                    if (this.currentScrollPointIndex > 0) {
                        this.lineStart = startChar = this.scrollPoints[this.currentScrollPointIndex];
                        styleRed = this.scrollStyleRed[this.currentScrollPointIndex];
                    } else if (this.currentScrollPoint >= 0) {
                        this.lineStart = startChar = this.currentScrollPoint;
                        styleRed = this.currentScrollStyle;
                    }
                    if (this.currentScrollPointIndex == -1) {
                        this.currentScrollPointIndex = 0;
                        this.scrollPoints[this.currentScrollPointIndex] = verseOffset;
                        this.scrollStyleRed[this.currentScrollPointIndex] = styleRed;
                    }
                    if (styleRed) {
                        g.setColor(this.christWordsColour);
                    }
                    this.scrollPoints[this.currentScrollPointIndex + 1] = 0;
                }
                if (startChar == verseOffset) {
                    g.setFont(boldFont);
                    String verseString = this.goBible.localizeDigits("" + (verseIndex + 1));
                    if (this.align == 0) {
                        g.drawString(verseString, this.drawX, this.y, 20);
                    } else if (this.align == 1) {
                        g.drawString(verseString, this.width - this.drawX, this.y, 24);
                    }
                    this.drawX += boldFont.stringWidth(verseString) + 5;
                }
                g.setFont(plainFont);
                for (int charIndex = startChar; charIndex < verseEnd && this.y + fontHeight <= this.height; ++charIndex) {
                    this.wrapCheck(verse, charIndex, textWrap, fontHeight, styleRed, g, plainFont, verseIndex, barHeight);
                    char currentChar = verse[charIndex];
                    if (currentChar == '\u0001') {
                        this.lastSpace = charIndex;
                        if (this.y + fontHeight > this.height) continue;
                        if (this.lineStart < charIndex) {
                            this.drawChars(g, verse, this.lineStart, charIndex - this.lineStart, this.drawX, this.y);
                            this.drawX += plainFont.charsWidth(verse, this.lineStart, charIndex - this.lineStart);
                            if (charIndex == verseEnd - 1) {
                                this.y += fontHeight;
                            }
                        }
                        this.lineStart = charIndex + 1;
                        if (!styleRed) {
                            g.setColor(this.christWordsColour);
                            styleRed = true;
                            continue;
                        }
                        g.setColor(this.textColour);
                        styleRed = false;
                        continue;
                    }
                    if (!this.isSpace(currentChar) || charIndex == startChar) continue;
                    this.lastSpace = charIndex;
                }
                if (this.y + fontHeight <= this.height && (this.lineStart < verseEnd || verseOffset == verseEnd)) {
                    this.wrapCheck(verse, verseEnd, textWrap, fontHeight, styleRed, g, plainFont, verseIndex, barHeight);
                    if (this.y + fontHeight <= this.height && (this.lineStart < verseEnd || verseOffset == verseEnd)) {
                        this.drawChars(g, verse, this.lineStart, verseEnd - this.lineStart, this.drawX, this.y);
                        this.lineStart = verseEnd;
                        this.y += fontHeight;
                    }
                }
                if (this.lineStart < verseEnd) {
                    if (verseIndex != this.goBible.currentVerseIndex) continue;
                    this.moreVerseDown = true;
                    continue;
                }
                if (verseIndex == numberOfVerses - 1) {
                    this.nextScrollPointVerse = -1;
                    continue;
                }
                this.nextScrollPointVerse = verseIndex + 1;
                this.nextScrollPoint = -1;
                this.nextScrollStyle = false;
            }
        } else if (this.mode == 3) {
            this.paintGoto(g);
        }
    }

    public static void drawString(Graphics g, String string, int x, int y, int anchor) {
        if (reverseCharacters) {
            char[] reversedChars = string.toCharArray();
            int length = reversedChars.length;
            for (int i = 0; i < length >> 1; ++i) {
                char temp = reversedChars[i];
                reversedChars[i] = reversedChars[length - i - 1];
                reversedChars[length - i - 1] = temp;
            }
            g.drawChars(reversedChars, 0, length, x, y, anchor);
        } else {
            g.drawString(string, x, y, anchor);
        }
    }

    private void drawChars(Graphics g, char[] verse, int offset, int length, int x, int y) {
        if (this.align == 1) {
            x = this.width - x;
        }
        if (reverseCharacters) {
            char[] reversed = new char[length];
            for (int i = 0; i < length; ++i) {
                reversed[i] = verse[offset + length - i - 1];
            }
            g.drawChars(reversed, 0, length, x, y, this.anchor);
        } else {
            g.drawChars(verse, offset, length, x, y, this.anchor);
        }
    }

    public static int SPtoCP(char sp1, char sp2) {
        int cp = (sp1 - 55296 << 10) + (sp2 - 56320) + 65536;
        return cp;
    }

    public static int isSurrogatePair(char ch) {
        if (ch >= '\ud800' && ch <= '\udbff') {
            return 1;
        }
        if (ch >= '\udc00' && ch <= '\udfff') {
            return 2;
        }
        return 0;
    }

    private boolean isBreakingCharacter(char ch) {
        boolean result = this.isSpace(ch);
        if (result) {
            return result;
        }
        switch (ch) {
            case '\t': 
            case '\u00ad': {
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isSpace(char ch) {
        boolean result = false;
        switch (ch) {
            case ' ': 
            case '\u1680': 
            case '\u2000': 
            case '\u2001': 
            case '\u2002': 
            case '\u2003': 
            case '\u2004': 
            case '\u2005': 
            case '\u2006': 
            case '\u2007': 
            case '\u2008': 
            case '\u2009': 
            case '\u200a': 
            case '\u200b': 
            case '\u205f': 
            case '\u3000': {
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isNonBreakingSpace(char ch) {
        boolean result = false;
        switch (ch) {
            case '\u00a0': 
            case '\u202f': 
            case '\u2060': {
                result = true;
                break;
            }
        }
        return result;
    }

    private void wrapCheck(char[] verse, int charIndex, int textWrap, int fontHeight, boolean styleRed, Graphics g, Font font, int verseIndex, int barHeight) {
        int x = font.charsWidth(verse, this.lineStart, charIndex - this.lineStart) + this.drawX;
        if (x >= textWrap) {
            int lineChars = this.lastSpace - this.lineStart;
            int charsToBackup = 0;
            if (this.lastSpace == -1) {
                charsToBackup = 1;
                char gz = verse[charIndex - 1];
                char gz1 = verse[charIndex - 2];
                if (BibleCanvas.isSurrogatePair(verse[charIndex - 1]) == 1) {
                    ++charsToBackup;
                }
                lineChars = charIndex - this.lineStart - charsToBackup;
            }
            if (this.y + fontHeight <= this.height && this.y + fontHeight > barHeight && lineChars >= 0) {
                this.drawChars(g, verse, this.lineStart, lineChars, this.drawX, this.y);
            }
            this.lineStart = this.lastSpace != -1 ? this.lastSpace + 1 : charIndex;
            this.lineStart = this.lastSpace != -1 ? this.lastSpace + 1 : charIndex - charsToBackup;
            this.lastSpace = -1;
            this.y += fontHeight;
            this.drawX = 3;
            if (this.y + fontHeight > this.height) {
                if (verseIndex == this.goBible.currentVerseIndex) {
                    if (this.scrollPoints[this.currentScrollPointIndex + 1] == 0) {
                        this.scrollPoints[this.currentScrollPointIndex + 1] = this.lineStart;
                        this.scrollStyleRed[this.currentScrollPointIndex + 1] = styleRed;
                    }
                } else {
                    this.nextScrollPointVerse = verseIndex;
                    this.nextScrollPoint = this.lineStart;
                    this.nextScrollStyle = styleRed;
                }
            }
        }
    }

    private void paintLoading(Graphics g) {
        Font font = Font.getFont((int)0, (int)1, (int)0);
        g.setFont(font);
        String message = GoBible.getString("UI-Loading") + "...";
        String bookName = this.goBible.bibleSource.getBookName(this.goBible.currentBookIndex);
        String referenceString = " " + this.goBible.bibleSource.getReferenceString(this.goBible.currentBookIndex, this.goBible.currentChapterIndex, this.goBible.currentVerseIndex);
        int bookNameWidth = font.stringWidth(bookName);
        int referenceStringWidth = font.stringWidth(referenceString);
        int messageWidth = font.stringWidth(message);
        int messageHeight = font.getHeight();
        if (bookNameWidth + referenceStringWidth > messageWidth) {
            messageWidth = bookNameWidth + referenceStringWidth;
        }
        int boxWidth = messageWidth + 10;
        int boxHeight = messageHeight * 4;
        boxWidth = boxWidth > this.width ? this.width : boxWidth;
        boxHeight = boxHeight > this.height ? this.height : boxHeight;
        int boxLeft = this.width - boxWidth >> 1;
        int boxTop = this.height - boxHeight >> 1;
        g.setGrayScale(128);
        g.drawRect(boxLeft + 1, boxTop + 1, boxWidth, boxHeight);
        g.setGrayScale(255);
        g.fillRect(boxLeft, boxTop, boxWidth, boxHeight);
        g.setGrayScale(0);
        g.drawRect(boxLeft, boxTop, boxWidth, boxHeight);
        g.drawString(message, this.width >> 1, this.height - 2 * messageHeight >> 1, 17);
        int referenceTop = (this.height - 2 * messageHeight >> 1) + messageHeight;
        if (bookNameWidth + referenceStringWidth < boxWidth) {
            int startX = this.width - (bookNameWidth + referenceStringWidth) >> 1;
            BibleCanvas.drawString(g, bookName, startX, referenceTop, 20);
            g.drawString(referenceString, startX + bookNameWidth, referenceTop, 20);
        } else {
            g.drawString(referenceString, boxWidth + boxLeft, referenceTop, 24);
            g.clipRect(0, 0, boxLeft + boxWidth - referenceStringWidth, this.height);
            BibleCanvas.drawString(g, bookName, boxLeft + 2, referenceTop, 20);
        }
    }

    public void paintGoto(Graphics g) {
        int verseWidth;
        int colonWidth;
        int chapterWidth;
        String currentChapter = this.goBible.localizeDigits("" + (this.selection[1] + this.goBible.bibleSource.getStartChapter(this.selection[0])));
        String currentVerse = this.goBible.localizeDigits("" + (this.selection[2] + 1));
        String[] bookNames = this.goBible.bibleSource.getBookNames();
        Font font = Font.getFont((int)0, (int)1, (int)GoBible.FONT_SIZE_MAP[this.goBible.fontSize]);
        g.setFont(font);
        int fontHeight = font.getHeight();
        int widest = 0;
        for (int i = 0; i < bookNames.length; ++i) {
            int width = font.stringWidth(bookNames[i]);
            if (width <= widest) continue;
            widest = width;
        }
        int spaceWidth = font.charWidth(' ');
        int passageWidth = widest + 2 * spaceWidth + (chapterWidth = font.stringWidth(currentChapter)) + spaceWidth + (colonWidth = font.charWidth(':')) + spaceWidth + (verseWidth = font.stringWidth(currentVerse));
        if (passageWidth > this.width - 2) {
            widest -= passageWidth - (this.width - 2);
            passageWidth = this.width - 2;
        }
        int passageLeft = this.width - passageWidth >> 1;
        int passageTop = this.height - fontHeight >> 1;
        int chapterRight = passageLeft + widest + 2 * spaceWidth + chapterWidth;
        int boxWidth = passageWidth + 20;
        int boxHeight = fontHeight + 20;
        boxWidth = this.width - 2;
        boxHeight = boxHeight > this.height - 2 ? this.height - 2 : boxHeight;
        int boxLeft = this.width - boxWidth >> 1;
        int boxTop = this.height - boxHeight >> 1;
        g.setGrayScale(128);
        g.drawRect(boxLeft + 1, boxTop + 1, boxWidth - 1, boxHeight - 1);
        g.setGrayScale(255);
        g.fillRect(boxLeft, boxTop, boxWidth - 1, boxHeight - 1);
        g.setGrayScale(0);
        g.drawRect(boxLeft, boxTop, boxWidth - 1, boxHeight - 1);
        g.setColor(0xE0E0FF);
        int halfSpace = spaceWidth >> 1;
        int doubleSpace = spaceWidth << 1;
        if (this.selectionIndex == 0) {
            g.fillRoundRect(passageLeft - spaceWidth, passageTop - spaceWidth, widest + spaceWidth, fontHeight + doubleSpace, 10, 10);
        } else if (this.selectionIndex == 1) {
            g.fillRoundRect(chapterRight - chapterWidth - halfSpace, passageTop - spaceWidth, chapterWidth + spaceWidth, fontHeight + doubleSpace, 10, 10);
        } else if (this.selectionIndex == 2) {
            g.fillRoundRect(chapterRight + spaceWidth + colonWidth + spaceWidth - halfSpace, passageTop - spaceWidth, verseWidth + spaceWidth, fontHeight + doubleSpace, 10, 10);
        }
        g.setGrayScale(0);
        g.drawString(currentChapter, chapterRight, passageTop, 24);
        g.drawString(" : " + currentVerse, chapterRight, passageTop, 20);
        g.clipRect(passageLeft, passageTop, widest, fontHeight);
        BibleCanvas.drawString(g, bookNames[this.selection[0]], passageLeft, passageTop, 20);
        if (this.goBible.fullScreen) {
            g.setClip(0, 0, this.width, this.height);
            g.setColor(-1);
            font = Font.getFont((int)0, (int)1, (int)16);
            g.setFont(font);
            int menuBoxHeight = font.getHeight() + 5;
            g.fillRect(0, this.height - menuBoxHeight, this.width, menuBoxHeight);
            this.drawButton(g, GoBible.getString("UI-Goto"), font, 1);
            font = Font.getFont((int)0, (int)0, (int)0);
            g.setFont(font);
            this.drawButton(g, GoBible.getString("UI-Cancel"), font, 8);
        }
    }

    public void drawButton(Graphics g, String label, Font font, int position) {
        int buttonWidth = font.stringWidth(label) + 4;
        int buttonHeight = font.getHeight() + 3;
        int buttonY = this.height - buttonHeight;
        int buttonX = 0;
        switch (position) {
            case 8: {
                buttonX = this.width - buttonWidth - 1;
                break;
            }
            case 1: {
                buttonX = (this.width >> 1) - (buttonWidth >> 1);
            }
        }
        g.setColor(0xE0E0FF);
        g.fillRoundRect(buttonX, buttonY, buttonWidth, buttonHeight + 10, 10, 10);
        g.setColor(0xC0C0FF);
        g.drawRoundRect(buttonX, buttonY, buttonWidth, buttonHeight + 10, 10, 10);
        g.setColor(-16777216);
        g.drawString(label, buttonX + 3, buttonY + 3, 20);
    }
}

